/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.init.world;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import projectvibrantjourneys.common.world.features.BarkMushroomFeature;
import projectvibrantjourneys.common.world.features.BushFeature;
import projectvibrantjourneys.common.world.features.CliffRockFeature;
import projectvibrantjourneys.common.world.features.CobwebFeature;
import projectvibrantjourneys.common.world.features.FallenTreeFeature;
import projectvibrantjourneys.common.world.features.JuniperTreeFeature;
import projectvibrantjourneys.common.world.features.OceanFloorSeashellsFeature;
import projectvibrantjourneys.common.world.features.SandBlockBlobFeature;
import projectvibrantjourneys.common.world.features.SandTreeFeature;
import projectvibrantjourneys.common.world.features.SnowMountainTreeFeature;
import projectvibrantjourneys.common.world.features.WaterCattailFeature;

@Mod.EventBusSubscriber(modid="projectvibrantjourneys", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PVJFeatures {
    public static final ArrayList<Feature<?>> FEATURES = new ArrayList();
    public static Feature<NoFeatureConfig> oceanFloorSeashellsFeature;
    public static Feature<ProbabilityConfig> bushFeature;
    public static Feature<NoFeatureConfig> waterCattailFeature;
    public static Feature<NoFeatureConfig> barkMushroomFeature;
    public static Feature<ProbabilityConfig> cobwebFeature;
    public static Feature<NoFeatureConfig> fallenTreeFeature;
    public static Feature<BaseTreeFeatureConfig> snowTree;
    public static Feature<BaseTreeFeatureConfig> sandTree;
    public static Feature<BaseTreeFeatureConfig> juniperTree;
    public static Feature<BlockStateFeatureConfig> sandRock;
    public static Feature<ProbabilityConfig> cliffRock;

    @SubscribeEvent
    public static void initFeatures(RegistryEvent.Register<Feature<?>> event) {
        oceanFloorSeashellsFeature = PVJFeatures.registerFeature(new OceanFloorSeashellsFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_), "ocean_floor_seashells_feature");
        bushFeature = PVJFeatures.registerFeature(new BushFeature((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_), "bush_feature");
        waterCattailFeature = PVJFeatures.registerFeature(new WaterCattailFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_), "water_cattail_feature");
        barkMushroomFeature = PVJFeatures.registerFeature(new BarkMushroomFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_), "bark_mushroom_feature");
        cobwebFeature = PVJFeatures.registerFeature(new CobwebFeature((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_), "cobweb_feature");
        fallenTreeFeature = PVJFeatures.registerFeature(new FallenTreeFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_), "fallen_tree_feature");
        snowTree = PVJFeatures.registerFeature(new SnowMountainTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_), "snow_tree");
        sandTree = PVJFeatures.registerFeature(new SandTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_), "sand_tree");
        juniperTree = PVJFeatures.registerFeature(new JuniperTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_), "juniper_tree");
        sandRock = PVJFeatures.registerFeature(new SandBlockBlobFeature((Codec<BlockStateFeatureConfig>)BlockStateFeatureConfig.field_236455_a_), "sand_rock");
        cliffRock = PVJFeatures.registerFeature(new CliffRockFeature((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_), "cliff_rock");
        FEATURES.forEach((Consumer<Feature<?>>)((Consumer<Feature>)feature -> event.getRegistry().register((IForgeRegistryEntry)feature)));
    }

    public static <FC extends IFeatureConfig> Feature<FC> registerFeature(Feature<FC> feature, String name) {
        feature.setRegistryName(new ResourceLocation("projectvibrantjourneys", name));
        FEATURES.add(feature);
        return feature;
    }
}

